
/*

  
	CEInfoWin.cpp 
	Author: Stephen Pendleton
	11/16/97
	
	  This file contains the functions to handle the "info window" or the rightmost
	  window.
*/

#include <windows.h>
#include <windowsx.h>
#include <Commctrl.h>
#include <string.h>
#include <malloc.h>

#ifndef _WIN32_WCE
#include <stdio.h>
#endif
#include "IrcCE.h"
#include "resource.h"


int InfoWinState;
HWND hWndInfoWin;
void AddNamesToInfoWin(const char *);

extern HWND hMainWnd;
extern HANDLE hInst;
extern int CLIENT_WIDTH;
extern int CLIENT_HEIGHT;
extern int CHANNEL_WINDOW_WIDTH;
extern int CHANNEL_WINDOW_HEIGHT;
struct Channel;
struct Names;
extern Channel * GetChannel(char *);
extern char * GetToken(const char * buffer, int *index, const char *seps);

/****************************************************************
Create the info window
*****************************************************************/

void CreateInfoWin()
{
	
	hWndInfoWin = CreateWindow(TEXT("LISTBOX"),TEXT(""),
		LBS_NOTIFY|WS_BORDER|WS_VISIBLE|WS_CHILD|LBS_SORT|WS_VSCROLL,
		0, 0,
		0, 0, hMainWnd,
		(HMENU)IDC_INFOWIN, hInst, NULL);
}

/****************************************************************
Toggle the info window visible/invisible
*****************************************************************/


void ShowInfoWin(int nCmdShow)
{
	ShowWindow(hWndInfoWin,nCmdShow);
	InfoWinState = nCmdShow;

	if (nCmdShow == SW_SHOW)
		CHANNEL_WINDOW_WIDTH = CLIENT_WIDTH - (100 + GetSystemMetrics(SM_CXVSCROLL));
	else
		CHANNEL_WINDOW_WIDTH = CLIENT_WIDTH - GetSystemMetrics(SM_CXVSCROLL);

	SendMessage(hMainWnd, WM_SIZE, 0, 0);
	InvalidateRect(hMainWnd,NULL,TRUE); 
	UpdateWindow(hMainWnd);

}

/****************************************************************
Add a single nickname to the info window
*****************************************************************/

void AddNameToInfoWin(const char *name)
{
#ifdef _WIN32_WCE
	WCHAR wname[40];
	mbstowcs( wname, name, strlen(name)+1); 
	SendMessage(hWndInfoWin, LB_ADDSTRING, (WPARAM)0, (LPARAM)wname);
#else
	SendMessage(hWndInfoWin, LB_ADDSTRING, (WPARAM)0, (LPARAM)name);
#endif
	
	
}

/****************************************************************
Add several nicknames to the info window. The parameter holds a
list of names seperated by spaces.
*****************************************************************/

void AddNamesToInfoWin(const char *names)
{

	char * name;
	int indexb, names_length;

	indexb=0;
	names_length = strlen(names);

	while (indexb < names_length)
	{
		name=GetToken(names,&indexb," \n");
		indexb++;
		AddNameToInfoWin(name);
		LocalFree(name);
	}
}

/****************************************************************
Removes a single nickname from the info window
*****************************************************************/

void RemoveNameFromInfoWin(const char *name)
{
	
	
	int index;
	
#ifdef _WIN32_WCE
	WCHAR wname[40];
	mbstowcs( wname, name, strlen(name)+1); 
	
	if ((index=SendMessage(hWndInfoWin, LB_FINDSTRINGEXACT, (WPARAM)-1, (LPARAM)wname))!=LB_ERR)
		
#else
		
		
		if ((index=SendMessage(hWndInfoWin, LB_FINDSTRINGEXACT, (WPARAM)-1, (LPARAM)name))!=LB_ERR)
			
			
#endif
			
			SendMessage(hWndInfoWin, LB_DELETESTRING, (WPARAM)index, (LPARAM)0);
}


/****************************************************************
Clears all names from the info window.
*****************************************************************/

void ClearNamesFromInfoWin()
{
	SendMessage(hWndInfoWin, LB_RESETCONTENT, (WPARAM)0, (LPARAM)0);
}

/****************************************************************
Fills the info window with names from a channel
*****************************************************************/

void FillInfoWin(char *channel)
{
	struct Channel * chan;
	struct Names * pNamesList;
	char aname[40];
#ifdef _WIN32_WCE
	WCHAR wname[40];
#endif

	chan = GetChannel(channel);
	ClearNamesFromInfoWin();
		
	pNamesList = chan->pNamesList;

	SendMessage(hWndInfoWin, WM_SETREDRAW ,FALSE, 0);

	while (pNamesList!=NULL)	
	{

		strcpy(aname,pNamesList->modes);
		strcat(aname,pNamesList->name);

#ifdef _WIN32_WCE
	mbstowcs( wname, aname, strlen(aname)+1); 
	SendMessage(hWndInfoWin, LB_ADDSTRING, (WPARAM)0, (LPARAM)wname);
#else
	SendMessage(hWndInfoWin, LB_ADDSTRING, (WPARAM)0, (LPARAM)aname);
#endif
		pNamesList = pNamesList->next;	

	}
	SendMessage(hWndInfoWin, WM_SETREDRAW ,TRUE, 0);
	InvalidateRect(hWndInfoWin , NULL, TRUE);
}

/****************************************************************
Changes a single nickname to the info window
*****************************************************************/

void ChangeNameInInfoWin(char *name, char *newname)
{

	int index;
#ifdef _WIN32_WCE
	WCHAR wname[40], wnewname[40];
	mbstowcs( wname, name, strlen(name)+1); 
	mbstowcs( wnewname, newname, strlen(newname)+1); 
	if ((index=SendMessage(hWndInfoWin, LB_FINDSTRINGEXACT, (WPARAM)-1, (LPARAM)wname))!=LB_ERR)
	{
#else
	if ((index=SendMessage(hWndInfoWin, LB_FINDSTRINGEXACT, (WPARAM)-1, (LPARAM)name))!=LB_ERR)
	{
#endif
		SendMessage(hWndInfoWin, LB_DELETESTRING, (WPARAM)index, (LPARAM)0);
#ifdef _WIN32_WCE
		SendMessage(hWndInfoWin, LB_ADDSTRING, (WPARAM)0, (LPARAM)wnewname);
#else
		SendMessage(hWndInfoWin, LB_ADDSTRING, (WPARAM)0, (LPARAM)newname);
#endif
	}


}
