
/*

  
	IrcCE.cpp 
	Author: Stephen Pendleton
	11/16/97
	
	  This file contains the main start up routines for the client and the 
	  WndProc and WinMain. It also contains the code for the ident server
	  and the main socket handlers and the DCC handlers.
*/


#include <windows.h>
#include <windowsx.h>
#include <Commctrl.h>
#include <Winsock.h>

#ifndef _WIN32_WCE
#include <stdio.h>
#endif


#include "IrcCE.h"
#include "resource.h"

#ifdef _WIN32_WCE
WCHAR szAppName[8];
WCHAR szTitle[8];
WCHAR servers[6][40];
#else
char szAppName[8]="IrcCE";
char szTitle[8]="IrcCE";
char servers[6][40];
#endif


int CLIENT_WIDTH;							// Width of client window
int CLIENT_HEIGHT;							// Height of client window
int CHANNEL_WINDOW_WIDTH;					// Width of chat window
int CHANNEL_WINDOW_HEIGHT;					// Height of chat window
int NumServers;								// Number of servers in connect dialog box combobox
HANDLE hWndBox,hWndCB,hMainWnd,hEditWnd,hChannelScrollBar,hInst=NULL; // Handles of various windows
PROC lpfnOldEditProc;
BOOL bMenu,badd,nshow,bflag;				// utility
SOCKET csock,ident_socket;								// main socket, identd socket
char Nickname[30],Servername[40],ServerPort[8],Userinfo[50];	//users nickname, servername,port, and userinfo
char CurChannel[100];						// holds the name of the current channel
struct sockaddr_in localhost;
int localhost_addrlen;
unsigned long identthreadid;
int FullScreenState;						// flag that knows if the client is full screen or not.
BOOL nickname_taken;						// flag that is TRUE when the users nickname is taken upon logging in
struct Channel;
struct Msg;
extern int InfoWinState;
extern unsigned int ScrollPosition;


LRESULT CALLBACK ConnectDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam); 
LRESULT CALLBACK AboutDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
DWORD WINAPI InitiateDCCSENDThreadHandler(LPVOID thread_param);
DWORD WINAPI AcceptDCCSENDThreadHandler(LPVOID remote_user);
void SaveServerListToRegistry(HANDLE hWndDlg);
DWORD LoadServerListFromRegistry(HANDLE hwndDlg);
BOOL MouseDown = FALSE;
extern void HandleUserInput();
extern LRESULT CALLBACK EditProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM uParam);
extern void Login();
extern void PrintToScreen(char *, char *);
extern char * ParseInString(char *, char *);
extern void SetupScreenBuffer();
extern void FreeScreenBuffer();
extern void PaintWindow (HDC hdc);
extern char * GetToken(const char * buffer, int *index, const char *seps);
extern void ActJoin(char * nick, char *channel);
extern Channel * CreateChannel(char *);
extern Channel * CloseChannel(char *name);
extern Channel * CloseAllChannels();
extern void CreateInfoWin();
extern void FillInfoWin(char *channel);
extern void ShowInfoWin(int nCmdShow);
extern void ClearNamesFromInfoWin();
extern void ShutdownSockets();
extern void WriteOutToSocket(SOCKET sock, char * buf);
extern void SetupNewChannel(char *channel, BOOL select_channel, int window_type, int socket);
extern void MakeChannelCurrent(char * channel);
extern char * GetNickname(char *nick);



extern struct Channel * pChannelList;
extern HANDLE ScreenBufferEvent;
extern HWND hWndInfoWin;
extern char * __cdecl strrchr (const char * string,int ch);



/****************************************************************
This function performs the ident service. It is started as a 
seperate thread.
*****************************************************************/

DWORD WINAPI IdentServerThreadHandler(LPVOID dummy)
{
	
	SOCKET os;
	int err;
	struct sockaddr peer_addr;
	struct sockaddr_in sin;
	int peer_addrlen;
	char buff[200];
	
	// create socket
	ident_socket=socket(AF_INET,SOCK_STREAM,0);
	if (ident_socket<0) 
        return INVALID_SOCKET;
	
	sin.sin_family = AF_INET; 
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	sin.sin_port = htons(113); 
    
	// listen on port 113
	if (bind(ident_socket, (LPSOCKADDR)&sin, sizeof (sin)) != 0)
		return 1;
	
	do 
	{
		err=listen(ident_socket,1);
		peer_addrlen=sizeof(peer_addr);
		os=accept(ident_socket,(struct sockaddr FAR *)&peer_addr,&peer_addrlen);
		PrintToScreen("IDENT REQUESTED\n","status");
		recv(os,buff,200,0);
		strcpy(buff,"1218,6667:USERID:UNIX:");
		strcat(buff,Nickname);
		strcat(buff,"\r\n");
		send(os,buff,strlen(buff),0);
		shutdown(os,2);
		closesocket(os);
		os = INVALID_SOCKET;
	} while (err==0); 
	
	shutdown(ident_socket,2);
	closesocket(ident_socket);
	ident_socket = INVALID_SOCKET;
	return 0;
	
}

/****************************************************************
This function creates the thread to start the ident
service.
*****************************************************************/

int WINAPI StartIdentServer()
{	
	if (CreateThread(NULL,0,IdentServerThreadHandler,NULL,0,&identthreadid)==NULL)
		return 1;
	
	return 0;	
}


/*****************************************************************
A utility function that takes a servername and port and returns a
connected socket to the host.
*****************************************************************/
SOCKET WINAPI ConnectToHost(char *servername, unsigned short port) 
{
	struct hostent *host;
	struct sockaddr_in remote;
	SOCKET sock;
	
	if (servername[0]>='1' && servername[0]<='9')
	{
		remote.sin_addr.s_addr=inet_addr(servername);
	}
	else
	{
		host=gethostbyname(servername);
		if (host==NULL) {
			return INVALID_SOCKET;
		}
		else 
		{
			memcpy((char *)&remote.sin_addr,(char *)host->h_addr, host->h_length);
		}
	}
	
	remote.sin_port=htons(port);
	remote.sin_family=AF_INET;
	sock=socket(AF_INET,SOCK_STREAM,0);
	if (sock<0) {
        return INVALID_SOCKET;
	}
	
	if (connect(sock,(struct sockaddr *)&remote, sizeof remote)<0) {
		return INVALID_SOCKET;
	}
	return sock;
	
}

/*****************************************************************
This function is run as a seperate thread and serves the main
socket functions.
******************************************************************/
DWORD WINAPI SocketThreadHandler(LPVOID dummy)
{
	
	int rb;
	char inbuf[200];
	char * out, *dest;
	int remote_port;
	MENUITEMINFO mii;
	HMENU hmenu;

#ifdef _WIN32_WCE
	WCHAR wport[10];

	mbstowcs( wport, ServerPort, 8 );
	remote_port = _wtoi(wport);
#else
	remote_port = atoi(ServerPort);
#endif	
	
	MakeChannelCurrent("status");
	strcpy(inbuf, "Connecting to server ");
	strcat(inbuf, Servername);
	strcat(inbuf, " on port ");
	strcat(inbuf, ServerPort);
	strcat(inbuf, "...\n");
	PrintToScreen(inbuf,"status");
	nickname_taken = FALSE;
	csock = ConnectToHost(Servername, remote_port);
	CloseAllChannels();
	if (csock == INVALID_SOCKET)
	{
		PrintToScreen("Cannot connect to server.\n","status");
		MessageBox(hMainWnd,TEXT("Cannot Connect To Host."),TEXT("Cannot Connect"),MB_OK);
		ExitThread(0);
		return 1;
	}
	else
		
		PrintToScreen("Connected to server.\n","status");

#ifdef _WIN32_WCE
	if ((hmenu = CommandBar_GetMenu(hWndCB, 0)) != NULL)
#else
	if ((hmenu = GetMenu(hMainWnd)) != NULL)
#endif
	{
		mii.fMask = MIIM_TYPE;
		mii.fType = MFT_STRING;
		mii.cbSize = sizeof(mii);
		GetMenuItemInfo(hmenu, IDC_CONNECT, FALSE, &mii); 
		mii.dwTypeData = TEXT("Disconnect");
		mii.cbSize = sizeof(mii);
		SetMenuItemInfo( hmenu, IDC_CONNECT, FALSE, &mii);
	}

	localhost_addrlen=sizeof(localhost);
	
	if (getsockname(csock,(struct sockaddr *)&localhost,&localhost_addrlen)==-1)
	{
		PrintToScreen("Could not get local IP.\n","status");
	}
	else
		PrintToScreen("Got local IP.\n","status");
	
	Login();
	

	dest=(char *)LocalAlloc(LMEM_FIXED ,500);
	
	do
	{
		recv(csock, inbuf, 1, 0);
		// read in up to 100 bytes
		rb = recv(csock, inbuf+1, 100, 0);
		if (rb==0 || rb==SOCKET_ERROR)
			break;
		
		inbuf[rb+1]=0;
		
		// parse the string
		out=ParseInString(inbuf,dest);
		// parse all remaining strings.
		do {
			if (out)
			{
				PrintToScreen(out,dest);
				LocalFree(out);
			}
			out=ParseInString("",dest);
		} while (out);
	} while (rb!=0 && rb!=SOCKET_ERROR);


#ifdef _WIN32_WCE
	if ((hmenu = CommandBar_GetMenu(hWndCB, 0)) != NULL)
#else
	if ((hmenu = GetMenu(hMainWnd)) != NULL)
#endif
	{
		mii.fMask = MIIM_TYPE;
		mii.fType = MFT_STRING;
		mii.cbSize = sizeof(mii);
		GetMenuItemInfo(hmenu, IDC_CONNECT, FALSE, &mii); 
		mii.dwTypeData = TEXT("Connect");
		mii.cbSize = sizeof(mii);
		SetMenuItemInfo( hmenu, IDC_CONNECT, FALSE, &mii);
	}
	

	// At this point the socket has been closed
	PrintToScreen("********Connection to server lost.*********\n","status");
	MessageBox(hMainWnd,TEXT("Connection to server lost."),TEXT("Connection Lost"),MB_OK);
	csock = INVALID_SOCKET;
	LocalFree(dest);
	ExitThread(0);
	return 0;
}

/*****************************************************************
This function services an incoming DCC CHAT request.
*****************************************************************/

DWORD WINAPI AcceptDCCCHATThreadHandler(LPVOID remote_user)
{
	
	char *buff, *nick, *address, *port, *outs;
	SOCKET s;
	int indexb, rb;
	struct sockaddr_in sin;
	
	
	
#ifdef _WIN32_WCE
	WCHAR wport[10];
	WCHAR waddress[20];
	WCHAR wnick[20];
	
	WCHAR * wbuff;
	wbuff = (WCHAR *)LocalAlloc(LMEM_FIXED, 500*sizeof(WCHAR));
#endif
	
	buff = (char *)LocalAlloc(LMEM_FIXED ,500);
	outs = (char *)LocalAlloc(LMEM_FIXED ,500);
	indexb = 0;
	nick = GetToken((const char *)remote_user, &indexb, " ");
	address = GetToken((const char *)remote_user, &indexb, " ");
	LocalFree(address);
	address = GetToken((const char *)remote_user, &indexb, " ");
	LocalFree(address);
	
	address = GetToken((const char *)remote_user, &indexb, " ");
	port = GetToken((const char *)remote_user, &indexb, " \n");
	
#ifdef _WIN32_WCE
	mbstowcs( waddress, address, 20 );
	mbstowcs( wport, port, 10 );
	sin.sin_addr.s_addr = htonl(_wtol(waddress));
	sin.sin_port = (unsigned short)_wtoi(wport);
#else
	sin.sin_addr.s_addr = htonl(atol(address));
	sin.sin_port = atoi(port);
#endif
	
#ifdef _WIN32_WCE
	
	mbstowcs( wnick, nick, 20 );
	wsprintf(wbuff, L"You have an incoming DCC CHAT request from\n%s\nDo you want to accept it?", wnick);
	if (MessageBox(NULL,wbuff,L"DCC CHAT",MB_OKCANCEL)==IDOK)
	{
		
#else
		sprintf(buff, "You have an incoming DCC CHAT request from\n%s at %s:%hu\nDo you want to accept it?", nick, inet_ntoa(sin.sin_addr),htons(sin.sin_port));
		
		if (MessageBox(NULL,buff,"DCC CHAT",MB_OKCANCEL)==IDOK)
		{
#endif	
			s = ConnectToHost(inet_ntoa(sin.sin_addr), sin.sin_port);
			
			if (s != INVALID_SOCKET)
			{
				
				PrintToScreen("DCC CONNECTION ACCEPTED\n","status");
				SetupNewChannel(nick, TRUE, WINDOW_TYPE_DCC_CHAT, s);
				
				
				do
				{
					recv(s, buff, 1, 0);
					rb = recv(s, buff+1, 100, 0);
					if (rb==0 || rb==SOCKET_ERROR)
						break;
					buff[rb+1]=0;
					
#ifdef _WIN32_WCE
					strcpy(outs, "<");
					strcat(outs, nick);
					strcat(outs, "> ");
					strcat(outs, buff);
#else
					sprintf(outs ,"<%s> %s\n", nick, buff);
#endif
					
					PrintToScreen(outs,nick);
				} while (rb!=0 && rb!=SOCKET_ERROR);
				
				PrintToScreen("DCC CHAT CLOSED.\n","status");
				
			}
			else
				PrintToScreen("DCC CONNECTION REJECTED\n","status");
			
			shutdown(s,2);
			closesocket(s);
			s = INVALID_SOCKET;
		}
		
#ifdef _WIN32_WCE
		LocalFree(wbuff);
#endif
		LocalFree(outs);
		LocalFree(buff);
		LocalFree((char *)remote_user);
		LocalFree(nick);
		LocalFree(address);
		LocalFree(port);
		return 0;
		
		
	}
	
	
	
	/*****************************************************************
	This function services a DCC SEND request.
	******************************************************************/
	DWORD WINAPI AcceptDCCSENDThreadHandler(LPVOID remote_user)
	{
		
		char *buff, *nick, *address, *port, *filename;
		SOCKET s;
		int indexb, rb, sr;
		struct sockaddr_in sin;
		HANDLE fp;
		unsigned long num_written, total_received, htotal;
		BOOL bResult;
		struct timeval to;
		fd_set rread;

		
		
#ifdef _WIN32_WCE
		WCHAR wport[10];
		WCHAR waddress[20];
		WCHAR wnick[20];
		WCHAR wfilename[255];
		WCHAR * wbuff;
		wbuff = (WCHAR *)LocalAlloc(LMEM_FIXED, 500*sizeof(WCHAR));
#endif
		
		buff = (char *)LocalAlloc(LMEM_FIXED ,1024);
		indexb = 0;
		nick = GetToken((const char *)remote_user, &indexb, " ");
		address = GetToken((const char *)remote_user, &indexb, " ");
		LocalFree(address);
		filename = GetToken((const char *)remote_user, &indexb, " ");
		
		address = GetToken((const char *)remote_user, &indexb, " ");
		port = GetToken((const char *)remote_user, &indexb, " \n");
		
#ifdef _WIN32_WCE
		mbstowcs( waddress, address, 20 );
		mbstowcs( wport, port, 10 );
		sin.sin_addr.s_addr = htonl(_wtol(waddress));
		sin.sin_port = (unsigned short)_wtoi(wport);
#else
		sin.sin_addr.s_addr = htonl(atol(address));
		sin.sin_port = atoi(port);
#endif
		
#ifdef _WIN32_WCE
		
		mbstowcs( wnick, nick, 20 );
		mbstowcs( wfilename, filename, 255);
		wsprintf(wbuff, L"You have an incoming DCC SEND request from\n%s for file %s\nDo you want to accept it?", wnick, wfilename);
		if (MessageBox(NULL,wbuff,L"DCC SEND",MB_OKCANCEL)==IDOK)
		{
			
#else
			sprintf(buff, "You have an incoming DCC SEND request from\n%s at %s:%hu for file %s\nDo you want to accept it?", nick, inet_ntoa(sin.sin_addr),htons(sin.sin_port),filename);
			
			if (MessageBox(NULL,buff,"DCC SEND",MB_OKCANCEL)==IDOK)
			{
#endif	
				s = ConnectToHost(inet_ntoa(sin.sin_addr), sin.sin_port);
				
				if (s != INVALID_SOCKET)
				{
					
					PrintToScreen("DCC SEND CONNECTION ACCEPTED\n","status");
					//SetupNewChannel(nick, TRUE, WINDOW_TYPE_DCC_CHAT, s);
#ifdef _WIN32_WCE	
					mbstowcs(wfilename,filename,250);
					fp = CreateFileW(wfilename,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
#else
					fp = CreateFile(filename,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
#endif
					if (fp!=INVALID_HANDLE_VALUE)
					{		
						total_received = 0;
						do
						{
							FD_ZERO(&rread);
							FD_SET(s,&rread);
							memset((char *)&to, 0 , sizeof(to));
							to.tv_sec = 5;
							sr = select(s+1, &rread, NULL,NULL, &to);
							
							rb = 0;
							if (sr>0 && FD_ISSET(s, &rread))
							{
								
								rb = recv(s, buff, 1024, 0);
								if (rb==0 || rb==SOCKET_ERROR)
									break;
							}
							//assume all thats been read is written
							bResult = WriteFile(fp, buff, rb, &num_written, NULL);
							total_received += num_written;
							htotal = htonl(total_received);
							send(s, (char *)&htotal, sizeof(htotal),0);
						} while ((bResult==TRUE) && rb!=0 && rb!=SOCKET_ERROR);
						
						CloseHandle(fp);	
					}
					else
						PrintToScreen("CANNOT OPEN OUTPUT FILE.\n","status");
					
					
				}
				shutdown(s,2);
				closesocket(s);
				s = INVALID_SOCKET;
				PrintToScreen("DCC FILE TRANSFER CLOSED.\n","status");
			}
			else
				PrintToScreen("DCC CONNECTION REJECTED\n","status");
			
#ifdef _WIN32_WCE
			LocalFree(wbuff);
#endif
			LocalFree(buff);
			LocalFree((char *)remote_user);
			LocalFree(nick);
			LocalFree(address);
			LocalFree(port);
			return 0;
			
			
		}
		
		/*****************************************************************
		This function initiates a DCC CHAT.
		*****************************************************************/
		
		DWORD WINAPI InitiateDCCCHATThreadHandler(LPVOID remote_user)
		{
			
			SOCKET s,os;
			int err,rb;
			struct sockaddr peer_addr;
			struct sockaddr_in sin;
			int peer_addrlen;
			char address_buffer[100];
			char * buff, *outs;
			
#ifdef _WIN32_WCE
			WCHAR waddress_buffer[100];
#endif
			
			buff = (char *)LocalAlloc(LMEM_FIXED ,500);
			outs = (char *)LocalAlloc(LMEM_FIXED ,500);
			
			short alport;
			
			alport = 1024;
			
			s=socket(AF_INET,SOCK_STREAM,0);
			if (s<0) 
				return INVALID_SOCKET;
			
			sin.sin_family = AF_INET; 
			sin.sin_addr.s_addr = htonl(INADDR_ANY);
			
			
			err = 1;
			
			while (alport < 5000 && err != 0)
			{
				sin.sin_port = htons(alport); 
				
				if ((err=bind(s, (LPSOCKADDR)&sin, sizeof (sin))) != 0)
				{
					if ( GetLastError() != WSAEADDRINUSE) 
					{ 	
						return -1;
					}  
					
					alport++; 
				}
			}
			
			
			
			if (alport > 5000)	
				return -1;
			
			
			
			
			err=listen(s,1);
			
			strcpy(buff, "PRIVMSG ");
			strcat(buff, (const char *)remote_user);
			strcat(buff," :\001DCC CHAT chat ");
#ifdef _WIN32_WCE
			
			wsprintf( waddress_buffer, L"%lu %hu\001\r\n",ntohl(localhost.sin_addr.s_addr), ntohs(sin.sin_port));  
			wcstombs( address_buffer, waddress_buffer, 100 );
#else
			
			sprintf(address_buffer, "%lu %hu\001\r\n",ntohl(localhost.sin_addr.s_addr), ntohs(sin.sin_port));  
#endif
			
			
			strcat(buff,address_buffer);
			WriteOutToSocket(csock, buff);
			
			os = INVALID_SOCKET;
			if (err==0)
			{
				peer_addrlen=sizeof(peer_addr);
				os=accept(s,(struct sockaddr FAR *)&peer_addr,&peer_addrlen);
				PrintToScreen("DCC ACCEPTED\n","status");
				SetupNewChannel((char *)remote_user, TRUE, WINDOW_TYPE_DCC_CHAT, os);
				do
				{
					recv(os, buff, 1, 0);
					rb = recv(os, buff+1, 100, 0);
					if (rb==0 || rb==SOCKET_ERROR)
						break;
					buff[rb+1]=0;
#ifdef _WIN32_WCE
					strcpy(outs, "<");
					strcat(outs, (char *)remote_user);
					strcat(outs, "> ");
					strcat(outs, buff);
#else
					sprintf(outs ,"<%s> %s\n", (char *)remote_user, buff);
#endif
					
					PrintToScreen(outs,(char *)remote_user);
				} while (rb!=0 && rb!=SOCKET_ERROR);
				
				PrintToScreen("DCC CHAT CLOSED.\n","status");
				
			}
			
			
			shutdown(s,2);
			closesocket(s);
			s = INVALID_SOCKET;
			if (os!=INVALID_SOCKET)
			{
				shutdown(os,2);
				closesocket(os);
				os = INVALID_SOCKET;
			}
			LocalFree(outs);
			LocalFree(buff);
			LocalFree((char *)remote_user);
			return 0;
			
			
			
}

/*****************************************************************
This function initiates a DCC SEND.
*****************************************************************/

DWORD WINAPI InitiateDCCSENDThreadHandler(LPVOID thread_param)
{
	
	SOCKET s,os;
	int err,rb;
	struct sockaddr peer_addr;
	struct sockaddr_in sin;
	int peer_addrlen,indexb, sr;
	unsigned int percent_done;
	DWORD file_length, num_sent;
	unsigned long num_read;
	char address_buffer[100];
	char *buff, *filename, *short_filename, *remote_user;
	struct timeval to;
	fd_set rread;
	HANDLE fp;
	BOOL bResult;
	
#ifdef _WIN32_WCE
	WCHAR waddress_buffer[100];
	WCHAR wfilename[250];
#endif
	
	buff = (char *)LocalAlloc(LMEM_FIXED ,1025);
	
	short alport;
	
	alport = 1024;
	
	s=socket(AF_INET,SOCK_STREAM,0);
	if (s<0) 
        return INVALID_SOCKET;
	
	sin.sin_family = AF_INET; 
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	
	
	err = 1;
	
	while (alport < 5000 && err != 0)
	{
		sin.sin_port = htons(alport); 
		
		if ((err=bind(s, (LPSOCKADDR)&sin, sizeof (sin))) != 0)
		{
			if ( GetLastError() != WSAEADDRINUSE) 
			{ 	
				return -1;
			}  
			
			alport++; 
		}
	}
	
	
	
	if (alport > 5000)	
		return -1;
	
	
	
	
	err=listen(s,1);
	indexb = 0;
	remote_user = GetToken((const char *)thread_param, &indexb, " ");
	filename = GetToken((const char *)thread_param, &indexb, "\n");
	
#ifdef _WIN32_WCE	
	mbstowcs(wfilename,filename,250);
	fp = CreateFileW(wfilename,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
#else
	fp = CreateFile(filename,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
#endif
	if (fp!=INVALID_HANDLE_VALUE)
	{
		file_length = GetFileSize(fp,NULL);
		if (file_length == 0)
			file_length++;
		strcpy(buff, "PRIVMSG ");
		strcat(buff, remote_user);
		strcat(buff," :\001DCC SEND ");
		if ((short_filename = strrchr(filename,'\\'))!=NULL)
			strcat(buff,short_filename+1);
		else
			strcat(buff,filename);
		strcat(buff," ");
#ifdef _WIN32_WCE
		
		wsprintf( waddress_buffer, L"%lu %hu\001\r\n",ntohl(localhost.sin_addr.s_addr), ntohs(sin.sin_port));  
		wcstombs( address_buffer, waddress_buffer, 100 );
#else
		
		sprintf(address_buffer, "%lu %hu\001\r\n",ntohl(localhost.sin_addr.s_addr), ntohs(sin.sin_port));  
#endif
		
		
		strcat(buff,address_buffer);
		WriteOutToSocket(csock, buff);
		os = INVALID_SOCKET;

		if (err==0)
		{
			peer_addrlen=sizeof(peer_addr);
			os=accept(s,(struct sockaddr FAR *)&peer_addr,&peer_addrlen);
			PrintToScreen("DCC SEND ACCEPTED\n","status");
			PrintToScreen("SENDING FILE\n","status");
			num_sent = 0;
			do
			{
				bResult = ReadFile(fp, buff, 1024, &num_read, NULL) ; 

				if (bResult == TRUE)
					num_sent += send(os, buff, num_read, 0);

				FD_ZERO(&rread);
				FD_SET(os,&rread);
				memset((char *)&to, 0 , sizeof(to));
				to.tv_sec = 3;
				sr = select(os+1, &rread, NULL,NULL, &to);

				rb = 0;
				if (sr>0 && FD_ISSET(os, &rread))
				{
					rb = recv(os, buff, 100, 0);
					if (rb==0 || rb==SOCKET_ERROR)
						break;
				}

				if (((percent_done = (int)(((float)num_sent/(float)file_length)*100.0)) % 10) == 0)
				{
					
#ifdef _WIN32_WCE
					wsprintf(wfilename, L"DCC SEND Status: %u percent completed.\n", percent_done);
					wcstombs(buff, wfilename, 100 );
#else
					sprintf(buff, "DCC SEND Status: %u percent completed.\n", percent_done);
#endif

					PrintToScreen(buff,"status");
				}
			} while ((bResult==TRUE) && (num_read>0) && rb!=0 && rb!=SOCKET_ERROR);
			
			PrintToScreen("DCC SEND CLOSED.\n","status");
			
		}
		
		
		
		if (os!=INVALID_SOCKET)
		{
			shutdown(os,2);
			closesocket(os);
			os = INVALID_SOCKET;
		}
		CloseHandle(fp);
	}

	else
		PrintToScreen("DCC ERROR - CANNOT OPEN FILE.\n","status");
	
	if (s!=INVALID_SOCKET)
	{
		shutdown(s,2);
		closesocket(s);
		s = INVALID_SOCKET;
	}
	
	LocalFree(buff);
	LocalFree((char *)thread_param);
	return 0;
	
	
	
}


/*****************************************************************
This function is handles the connection dialog box and starts a
connection request.
*****************************************************************/

LRESULT CALLBACK ConnectDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
#ifdef _WIN32_WCE
	WCHAR Temp[80];
#else
	char Temp[80];
#endif
	HANDLE hItemWnd;
	DWORD disp;
	HKEY hkeya;
	int i;
	unsigned long type, size;
	
	switch(uMsg)
	{
	case WM_INITDIALOG:

#ifdef _WIN32_WCE
				
		size = sizeof(Temp);

	/*	RegCreateKeyEx(HKEY_CURRENT_USER,L"Software\\IrcCE",0,L"REG_SZ",0,0,NULL,&hkeya,&disp); 
		if (RegDeleteValue(hkeya, L"Serverlist")!=ERROR_SUCCESS)
			MessageBox(NULL,L"ERROR",L"ERROR",MB_OK);
		RegCloseKey(hkeya);
	*/	
		RegCreateKeyEx(HKEY_CURRENT_USER,L"Software\\IrcCE",0,L"REG_SZ",0,0,NULL,&hkeya,&disp); 
		if (RegQueryValueEx(hkeya,L"CENickname",NULL,&type,(LPBYTE)Temp,&size)!=ERROR_SUCCESS)
		{
			mbstowcs( Temp, Nickname, 20 );
			size = (lstrlen(Temp) + 1)*sizeof(WCHAR);
			RegSetValueEx(hkeya,L"CENickname",0,REG_SZ,(LPBYTE)Temp,size);
		}
		else
			wcstombs(Nickname, Temp, 40 );

		size = sizeof(Temp);

		if (RegQueryValueEx(hkeya,L"CEUserinfo",NULL,&type,(LPBYTE)Temp,&size)!=ERROR_SUCCESS)
		{
			mbstowcs( Temp, Userinfo, 20 );
			size = (lstrlen(Temp) + 1)*sizeof(WCHAR);
			RegSetValueEx(hkeya,L"CEUserinfo",0,REG_SZ,(LPBYTE)Temp,size);
		}
		else
			wcstombs(Userinfo, Temp, 40 );
	
		i = LoadServerListFromRegistry(hwndDlg);

#else

		size = sizeof(Temp);
		RegCreateKeyEx(HKEY_CURRENT_USER,"Software\\IrcCE",0,"REG_SZ",0,0,NULL,&hkeya,&disp); 
		if (RegQueryValueEx(hkeya,"CENickname",NULL,&type,(LPBYTE)Temp,&size)!=ERROR_SUCCESS)
		{
			strcpy(Temp, Nickname);
			size = strlen(Temp);
			RegSetValueEx(hkeya,"CENickname",0,REG_SZ,(LPBYTE)Temp,size);
		}
		else
			strcpy(Nickname, Temp);

				
		size = sizeof(Temp);
		if (RegQueryValueEx(hkeya,"CEUserinfo",NULL,&type,(LPBYTE)Temp,&size)!=ERROR_SUCCESS)
		{
			strcpy(Temp, Userinfo);
			RegSetValueEx(hkeya,"CEUserinfo",0,REG_SZ,(LPBYTE)Temp,size);
		}
		else
			strcpy(Userinfo, Temp);
		i = LoadServerListFromRegistry(hwndDlg);
#endif

		RegCloseKey(hkeya);

		hItemWnd=GetDlgItem(hwndDlg,IDC_SERVER);
		
		// if no servers were loaded from the registry...
		if (i==0)
		{
			for (i=0;i<NumServers;i++)
			{
				SendMessage(hItemWnd,CB_ADDSTRING,0,(LPARAM)servers[i]);
			}
		}
		SendMessage(hItemWnd, CB_SETCURSEL,(WPARAM)0,0);
		hItemWnd=GetDlgItem(hwndDlg,IDC_NICK);
#ifdef _WIN32_WCE
		mbstowcs( Temp, Nickname, 20 );
#else
		strcpy(Temp,Nickname);
#endif
		
		SendMessage(hItemWnd,WM_SETTEXT,0,(LPARAM)Temp);
		hItemWnd=GetDlgItem(hwndDlg,IDC_USERINFO);
#ifdef _WIN32_WCE
		mbstowcs( Temp, Userinfo, 20 );
#else
		strcpy(Temp,Userinfo);
#endif
		SendMessage(hItemWnd,WM_SETTEXT,0,(LPARAM)Temp);
		hItemWnd=GetDlgItem(hwndDlg,IDC_PORT);
#ifdef _WIN32_WCE
		mbstowcs( Temp, ServerPort, 8);
#else
		strcpy(Temp,ServerPort);
#endif
		SendMessage(hItemWnd,WM_SETTEXT,0,(LPARAM)Temp);

		return TRUE;
		
	case WM_COMMAND:
		switch(wParam)
		{
		case IDOK:
			GetDlgItemText(hwndDlg,IDC_SERVER,Temp,80); 
#ifdef _WIN32_WCE
			wcstombs( Servername, Temp, 40 );
			GetDlgItemText(hwndDlg,IDC_PORT,Temp,6); 
			wcstombs( ServerPort, Temp, 20 );
			GetDlgItemText(hwndDlg,IDC_NICK,Temp,20); 
			wcstombs( Nickname, Temp, 20 );
			GetDlgItemText(hwndDlg,IDC_USERINFO,Temp,40); 
			wcstombs( Userinfo, Temp, 40 );
#else
			strcpy(Servername,Temp);
			GetDlgItemText(hwndDlg,IDC_PORT,Temp,6); 
			strcpy(ServerPort,Temp);
			GetDlgItemText(hwndDlg,IDC_NICK,Temp,20); 
			strcpy(Nickname,Temp);
			GetDlgItemText(hwndDlg,IDC_USERINFO,Temp,40); 
			strcpy(Userinfo,Temp);
#endif
			
#ifdef _WIN32_WCE
							
			RegCreateKeyEx(HKEY_CURRENT_USER,L"Software\\IrcCE",0,L"REG_SZ",0,0,NULL,&hkeya,&disp); 
			mbstowcs( Temp, Nickname, 20 );
			size = (lstrlen(Temp) + 1) * sizeof(WCHAR);
			RegSetValueEx(hkeya,L"CENickname",0,REG_SZ,(LPBYTE)Temp,size);
			mbstowcs( Temp, Userinfo, 40 );
			size = (lstrlen(Temp) + 1) * sizeof(WCHAR);
			RegSetValueEx(hkeya,L"CEUserinfo",0,REG_SZ,(LPBYTE)Temp,size);	
			mbstowcs( Temp, ServerPort, 20 );
			size = (lstrlen(Temp) + 1) * sizeof(WCHAR);
			RegSetValueEx(hkeya,L"CEServerPort",0,REG_SZ,(LPBYTE)Temp,size);
#else
			RegCreateKeyEx(HKEY_CURRENT_USER,"Software\\IrcCE",0,"REG_SZ",0,0,NULL,&hkeya,&disp); 
			strcpy(Temp, Nickname);
			size = (strlen(Temp) + 1);
			RegSetValueEx(hkeya,"CENickname",0,REG_SZ,(LPBYTE)Temp,size);
			strcpy(Temp, Userinfo);
			size = (strlen(Temp) + 1);
			RegSetValueEx(hkeya,"CEUserinfo",0,REG_SZ,(LPBYTE)Temp,size);
			strcpy(Temp, ServerPort);
			size = (strlen(Temp) + 1);
			RegSetValueEx(hkeya,"CEServerPort",0,REG_SZ,(LPBYTE)Temp,size);	
#endif
			RegCloseKey(hkeya);
			SaveServerListToRegistry(hwndDlg);			
			EndDialog(hwndDlg,0);
			return TRUE;
		case IDCANCEL:
			SaveServerListToRegistry(hwndDlg);
			EndDialog(hwndDlg,1);
			return TRUE;
		case IDC_DELSERVER:
			GetDlgItemText(hwndDlg,IDC_SERVER,Temp,80); 
			hItemWnd=GetDlgItem(hwndDlg,IDC_SERVER);
			if ((i = SendMessage(hItemWnd, CB_FINDSTRINGEXACT, -1, (LPARAM)Temp))!=CB_ERR)
			{
				SendMessage(hItemWnd, CB_DELETESTRING,i,0);
				SendMessage(hItemWnd, CB_SETCURSEL,i,0);
				SaveServerListToRegistry(hwndDlg);
			}
			return TRUE;
		}
		break;
	}
	return 0;
}

void SaveServerListToRegistry(HANDLE hwndDlg)
{
	
	DWORD disp, numservers;
	long i;
	HKEY hkeya;
	HANDLE hItemWnd;
	
#ifdef _WIN32_WCE
	WCHAR Temp[80];
	WCHAR sname[20];
#else
	char Temp[80];
	char sname[20];
#endif

	hItemWnd=GetDlgItem(hwndDlg,IDC_SERVER);	
	SendMessage(hItemWnd, WM_GETTEXT, (WPARAM)sizeof(Temp), (LPARAM)(char *)Temp);
	
	if (SendMessage(hItemWnd, CB_FINDSTRINGEXACT, (WPARAM)-1, (LPARAM)(char *)Temp)==CB_ERR)
		SendMessage(hItemWnd,CB_ADDSTRING,0,(LPARAM)Temp);
	
	i = SendMessage(hItemWnd, CB_GETCOUNT, 0, 0);
	i--;

#ifdef _WIN32_WCE
	if (RegCreateKeyEx(HKEY_CURRENT_USER,L"Software\\IrcCE",0,L"REG_SZ",0,0,NULL,&hkeya,&disp)!=ERROR_SUCCESS)
#else
	if (RegCreateKeyEx(HKEY_CURRENT_USER,"Software\\IrcCE",0,"REG_SZ",0,0,NULL,&hkeya,&disp)!=ERROR_SUCCESS)
#endif
		return;

	numservers = 0;
	while (i>=0 && i!=CB_ERR)		
	{

		SendMessage(hItemWnd, CB_GETLBTEXT, i, (LPARAM)(char *)Temp);
#ifdef _WIN32_WCE
		wsprintf(sname, L"CEServer%d",i);
		RegSetValueEx(hkeya, sname ,0 ,REG_SZ ,(LPBYTE)Temp ,(lstrlen(Temp)+1)*sizeof(WCHAR));
#else
		sprintf(sname, "CEServer%d",i);
		RegSetValueEx(hkeya, sname ,0 ,REG_SZ ,(LPBYTE)Temp ,strlen(Temp)+1);
#endif
		
		i--;
		numservers++;
	} 
				
#ifdef _WIN32_WCE
		RegSetValueEx(hkeya, L"CENumservers" ,0 ,REG_DWORD ,(LPBYTE)&numservers ,sizeof(numservers));
#else
		RegSetValueEx(hkeya, "CENumservers" ,0 ,REG_DWORD ,(LPBYTE)&numservers ,sizeof(numservers));
#endif
	RegCloseKey(hkeya);							
}

DWORD LoadServerListFromRegistry(HANDLE hwndDlg)
{
	
	DWORD disp;
	DWORD size, type;
	HKEY hkeya;
	HANDLE hItemWnd;
	DWORD numservers, i;
	
#ifdef _WIN32_WCE
	WCHAR server[80];
	WCHAR sname[20];
#else
	char server[80];
	char sname[20];
#endif

	size = sizeof(DWORD);
	type = REG_DWORD;
	
#ifdef _WIN32_WCE
	RegCreateKeyEx(HKEY_CURRENT_USER,L"Software\\IrcCE",0,L"REG_SZ",0,0,NULL,&hkeya,&disp); 
	if (RegQueryValueEx(hkeya,L"CENumservers",NULL,&type,(LPBYTE)&numservers,&size)!=ERROR_SUCCESS)
		return 0;
#else
	RegCreateKeyEx(HKEY_CURRENT_USER,"Software\\IrcCE",0,"REG_SZ",0,0,NULL,&hkeya,&disp); 
	if (RegQueryValueEx(hkeya,"CENumservers",NULL,&type,(LPBYTE)&numservers,&size)!=ERROR_SUCCESS)
		return 0;
#endif

		hItemWnd=GetDlgItem(hwndDlg,IDC_SERVER);
	 			

		i = 0;
		while (i<numservers)
		{
		
#ifdef _WIN32_WCE
			wsprintf(sname,L"CEServer%d",i);			
#else
			sprintf(sname,"CEServer%d",i);
#endif
				
			size = sizeof(server);
			type = REG_SZ;
			if (RegQueryValueEx(hkeya,sname,NULL,&type,(LPBYTE)server,&size)==ERROR_SUCCESS)
			{
				SendMessage(hItemWnd,CB_ADDSTRING,0,(LPARAM)server);
			}
			i++;
		}
	
	return i;
}
/*****************************************************************
This handles the about box.
*****************************************************************/

LRESULT CALLBACK AboutDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	
	switch(uMsg)
	{
	case WM_INITDIALOG:

		return TRUE;
		
	case WM_COMMAND:
		switch(wParam)
		{
		case IDOK:
			EndDialog(hwndDlg,0);
			return TRUE;
		}
		break;
	}
	return 0;
}

/*****************************************************************
The main menu handler
*****************************************************************/

VOID NEAR PASCAL HandleMenuCommands (HWND hWnd, WPARAM uParam, LPARAM lParam)
{
	
	DWORD threadid, dwLBIndex;
	HANDLE thread_handle;
	int index;
	char temp[100];
	char * nick;
#ifdef _WIN32_WCE
	WCHAR buff[100];
#else
	char buff[100];
#endif
	
	switch (GET_WM_COMMAND_ID(uParam, lParam))
	{
		
	case IDC_CHANNELBOX:
		
		if( HIWORD(uParam) == CBN_SELENDOK)
		{
			if ((index=SendMessage(hWndBox,CB_GETCURSEL,0,0))!=CB_ERR)
			{
				if (SendMessage(hWndBox,CB_GETLBTEXT,(WPARAM)index,(LPARAM)buff)!=CB_ERR)
				{
#ifdef _WIN32_WCE
					wcstombs(temp,buff,100);
					MakeChannelCurrent(temp);
#else
					MakeChannelCurrent(buff);
#endif
				}
				
			}
			
			
		}	
		break;
		
		
	case IDC_INFOWIN:
		if (HIWORD(uParam) == LBN_DBLCLK)
		{
			if ((dwLBIndex = SendMessage(hWndInfoWin, LB_GETCURSEL, 0, 0))!=LB_ERR)
			{
#ifdef _WIN32_WCE
				if (SendMessage(hWndInfoWin, LB_GETTEXT, (WPARAM)dwLBIndex, (LPARAM)buff)!=LB_ERR)
				{
					
					wcstombs(temp, buff, 40);
					nick = GetNickname(temp);
					SetupNewChannel(nick, TRUE, WINDOW_TYPE_CHANNEL, csock);
				}
#else
				if (SendMessage(hWndInfoWin, LB_GETTEXT, (WPARAM)dwLBIndex, (LPARAM)temp)!=LB_ERR)
				{
					nick = GetNickname(temp);
					SetupNewChannel(nick, TRUE, WINDOW_TYPE_CHANNEL, csock);
				}
#endif
			}
		}
		break;
		
	case IDC_EXIT:
		PostQuitMessage(0);
		break;
 		
	case IDC_CONNECT:

		if (csock == INVALID_SOCKET)
		{
			if (DialogBox(hInst,MAKEINTRESOURCE(IDD_CONNECT),hWnd,(DLGPROC)ConnectDialogProc)==0) 
				thread_handle = CreateThread(NULL,0,SocketThreadHandler,NULL,0,&threadid); 
		}

		else
		{
			shutdown(csock, 2);
			closesocket(csock);
			csock = INVALID_SOCKET;
		}
		break;
		
	case ID_ABOUT:
		DialogBox(hInst,MAKEINTRESOURCE(IDD_ABOUT),hWnd,(DLGPROC)AboutDialogProc);
		break;
		
	case ID_SHOWINFOWIN:
		InfoWinState = (InfoWinState==SW_SHOW) ? SW_HIDE : SW_SHOW;
		ShowInfoWin(InfoWinState);
#ifdef _WIN32_WCE
		CheckMenuItem(CommandBar_GetMenu(hWndCB, 0), ID_SHOWINFOWIN, (InfoWinState==SW_SHOW) ? MF_CHECKED : MF_UNCHECKED); 
#else
		CheckMenuItem(GetMenu(hMainWnd), ID_SHOWINFOWIN, (InfoWinState==SW_SHOW) ? MF_CHECKED : MF_UNCHECKED); 
#endif
		break;
	case ID_FULLSCREEN:
		FullScreenState = (FullScreenState==SW_SHOW) ? SW_HIDE : SW_SHOW;
		
#ifdef _WIN32_WCE
		CheckMenuItem(CommandBar_GetMenu(hWndCB, 0), ID_FULLSCREEN, (FullScreenState==SW_SHOW) ? MF_CHECKED : MF_UNCHECKED); 
#else
		CheckMenuItem(GetMenu(hMainWnd), ID_FULLSCREEN, (FullScreenState==SW_SHOW) ? MF_CHECKED : MF_UNCHECKED); 
#endif
		SendMessage(hMainWnd, WM_SIZE, 0, 0);
		InvalidateRect(hMainWnd,NULL,TRUE); 
		UpdateWindow(hMainWnd);
		break;

	case ID_CLOSE_CURRENT_VIEW:
		CloseChannel(CurChannel);
		break;
		
		
	}
}

/*****************************************************************
Sets up the command bar.
*****************************************************************/

VOID NEAR PASCAL SetupCommandBar(HWND hWnd)
{
	
#ifdef _WIN32_WCE
	hWndCB = CommandBar_Create(hInst,hWnd,IDC_CBAR);
	bMenu =CommandBar_InsertMenubar(hWndCB, hInst, DEFAULT_MENU, 0);
	
	hWndBox= CommandBar_InsertComboBox(hWndCB,hInst,200,CBS_DROPDOWNLIST|WS_VSCROLL,IDC_CHANNELBOX,1); 
	badd = CommandBar_AddAdornments(hWndCB, 0, 0);
	nshow = CommandBar_Show(hWndCB, TRUE);
	bflag=(int)CommandBar_IsVisible( hWndCB,);
#else
	hWndBox = CreateWindow(TEXT("COMBOBOX"),TEXT(""),
		CBS_DROPDOWNLIST|WS_VISIBLE | WS_CHILD,
		480, 0,
		100, 200, hWnd,
		(HMENU) IDC_CHANNELBOX, hInst, NULL);
	ShowWindow(hWndBox,SW_SHOW);
#endif	
	
}
/**************************************************************************

  Main Window Procedure.
  
	WndProc(	HWND hWnd, UINT message,WPARAM uParam,LPARAM lParam)
	
*************************************************************************/

LRESULT CALLBACK WndProc (	HWND hWnd,
						  UINT message,
						  WPARAM uParam,
						  LPARAM lParam)
{
    HDC hdc;
    PAINTSTRUCT ps;
	int nScrollCode, nPos, update, barHeight;
	SCROLLINFO si;
	RECT clientrect;
	
    switch (message) {
		
		
	case WM_COMMAND:	
		HandleMenuCommands(hWnd,uParam, lParam);          
		break;
		
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		PaintWindow(hdc);
		EndPaint(hWnd, &ps);
		break;
		
	case WM_CREATE:
		

		SetupCommandBar(hWnd);
		
		hEditWnd = CreateWindow(TEXT("EDIT"),TEXT(""),
			WS_BORDER| WS_VISIBLE | WS_CHILD | ES_AUTOHSCROLL,
			0, 0,
			0, 0, hWnd,
			(HMENU) IDC_USEREDIT, hInst, NULL);
		
		lpfnOldEditProc = (PROC)GetWindowLong(hEditWnd, GWL_WNDPROC);
		SetLastError(0);
		if (SetWindowLong(hEditWnd, GWL_WNDPROC, (LONG)EditProc)==0)
		{
			DWORD err = GetLastError();
#ifdef _WIN32_WCE
			MessageBox(NULL,L"Cannot set edit window procedure",L"Error",MB_OK);
#else
			MessageBox(NULL,"Cannot set edit window procedure","Error",MB_OK);
#endif
		}
		
		hChannelScrollBar = CreateWindow(TEXT("SCROLLBAR"),TEXT(""),
			WS_VISIBLE | WS_CHILD | SBS_VERT,
			0, 0,
			0, 0, hWnd,
			(HMENU) IDC_CHANNELSCROLLBAR, hInst, NULL);
		
		ScrollPosition = 0;
		si.cbSize = sizeof(si);
		si.fMask = SIF_RANGE | SIF_POS;
		si.nMin = 0;
		si.nPos = (int)NUM_SCREEN_LINES;
		si.nMax = NUM_SCREEN_LINES;
		SendMessage(hChannelScrollBar,SBM_SETSCROLLINFO,(WPARAM)TRUE,(LPARAM) &si);
		break;

	case WM_CLOSE:
#ifdef _WIN32_WCE
		CommandBar_Destroy(hWndCB);
#endif
		DestroyWindow(hMainWnd);
		ShutdownSockets();
		FreeScreenBuffer();
		break;

	case WM_DESTROY:
    	PostQuitMessage(0);
		break;

		
	case WM_SETFOCUS:
		SetFocus(hEditWnd);
		break;
		
	case WM_SIZE:
		GetClientRect(hMainWnd, &clientrect);
		CHANNEL_WINDOW_WIDTH = clientrect.right - clientrect.left;
		CHANNEL_WINDOW_HEIGHT = clientrect.bottom - clientrect.top - 20;

#ifdef _WIN32_WCE
		if (FullScreenState==SW_SHOW)
			CHANNEL_WINDOW_HEIGHT +=GetSystemMetrics(SM_CYMENU);
		barHeight = CommandBar_Height(hWndCB);
#else
		barHeight = 0;
#endif
		if (IsWindowVisible(hWndInfoWin))
		{
			CHANNEL_WINDOW_WIDTH += (-100 - GetSystemMetrics(SM_CXVSCROLL));
			MoveWindow(hWndInfoWin, CHANNEL_WINDOW_WIDTH + GetSystemMetrics(SM_CXVSCROLL), barHeight ,100, CHANNEL_WINDOW_HEIGHT - barHeight, TRUE);
		}
		else 
			CHANNEL_WINDOW_WIDTH -= GetSystemMetrics(SM_CXVSCROLL);
		
		MoveWindow(hEditWnd, 0, CHANNEL_WINDOW_HEIGHT, CLIENT_WIDTH, 20, TRUE);
		MoveWindow(hChannelScrollBar, CHANNEL_WINDOW_WIDTH, barHeight, GetSystemMetrics(SM_CXVSCROLL), CHANNEL_WINDOW_HEIGHT - barHeight, TRUE);
		break;
	

	case WM_VSCROLL:
		nScrollCode = (int)LOWORD(uParam);
		nPos = (short int)HIWORD(uParam);
		
		update = 0;
		switch (nScrollCode)
		{
		case SB_LINEDOWN:
			
			if (ScrollPosition > 0)
			{
				update = 1;
				ScrollPosition--;
			}
			
			break;
			
		case SB_LINEUP:
			
			ScrollPosition++;
			update = 1;
			
			break;
		case SB_THUMBTRACK:
			if (nPos > NUM_SCREEN_LINES)
				nPos = NUM_SCREEN_LINES;
			
			update = 1;
			ScrollPosition = NUM_SCREEN_LINES - nPos;
			break;
		}
		
		if (update == 1)
		{
			clientrect.left = 0;
			clientrect.right = CHANNEL_WINDOW_WIDTH;
			clientrect.top = 0;
			clientrect.bottom = CHANNEL_WINDOW_HEIGHT;
			
			InvalidateRect(hMainWnd,&clientrect,TRUE); 
			UpdateWindow(hMainWnd);
			
			si.cbSize = sizeof(si);
			si.fMask = SIF_POS;
			si.nPos = NUM_SCREEN_LINES - ScrollPosition;
			SendMessage(hChannelScrollBar,SBM_SETSCROLLINFO,(WPARAM)TRUE,(LPARAM) &si);
		}
		break;
				
		default:
			return (DefWindowProc(hWnd, message, uParam, lParam));
    }
	
    return (0);
}

/***************************************************************************

		BOOL InitApplication (HINSTANCE hInstance)
		
****************************************************************************/
BOOL InitApplication (HINSTANCE hInstance)		  
{
#ifdef _WIN32_WCE
	WNDCLASSW wc;
#else
	WNDCLASS wc;
#endif
	
	hInst = hInstance; 
	wc.style = 0 ;
	wc.lpfnWndProc = (WNDPROC) WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon  = (HICON)LoadImage(hInstance, MAKEINTRESOURCE(IDI_APPICON), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	
	wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
#ifdef _WIN32_WCE
	wc.hCursor = NULL;
	wc.lpszMenuName = NULL;
#else
	wc.hCursor = LoadCursor(hInstance, IDC_ARROW);
	wc.lpszMenuName = MAKEINTRESOURCE(DEFAULT_MENU);
#endif
	
	wc.lpszClassName = szAppName;
	
	BOOL f = (RegisterClass(&wc));
	
	
	return f;
}
/*************************************************************************************

  BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
  
************************************************************************************/

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	WSADATA ws;
	// Use the default window settings.
#ifdef _WIN32_WCE
	CLIENT_WIDTH = GetSystemMetrics(SM_CXSCREEN);
	CLIENT_HEIGHT = GetSystemMetrics(SM_CYSCREEN) - GetSystemMetrics(SM_CYMENU);
	CHANNEL_WINDOW_HEIGHT = CLIENT_HEIGHT - 20;
#else
	CLIENT_WIDTH = 700;
	CLIENT_HEIGHT = 240;
	CHANNEL_WINDOW_HEIGHT = CLIENT_HEIGHT - 20;
#endif
	CHANNEL_WINDOW_WIDTH = CLIENT_WIDTH - 115;
	FullScreenState = SW_HIDE;
#ifdef _WIN32_WCE
	hMainWnd = CreateWindowEx(0,szAppName,szTitle,WS_VISIBLE,
		CW_USEDEFAULT,CW_USEDEFAULT,CLIENT_WIDTH,CLIENT_HEIGHT,
		NULL, NULL, hInstance, NULL);
#else
	hMainWnd = CreateWindowEx(0,szAppName,szTitle,WS_VISIBLE|WS_SYSMENU,
		CW_USEDEFAULT,CW_USEDEFAULT,CLIENT_WIDTH,CLIENT_HEIGHT,
		NULL, NULL, hInstance, NULL);
#endif

	ShowWindow(hMainWnd, SW_SHOW);
	
	pChannelList = NULL;
	SetupNewChannel("status", TRUE, WINDOW_TYPE_CHANNEL, csock);
	MakeChannelCurrent("status");
	ScreenBufferEvent=CreateEvent(NULL,FALSE,TRUE,NULL); 
	
	
#ifdef _WIN32_WCE
	wcscpy(servers[0],L"irc.gate.net");
	wcscpy(servers[1],L"irc.emory.edu");
	wcscpy(servers[2],L"irc.ais.net");	
	wcscpy(servers[3],L"irc.stealth.net");
	wcscpy(servers[4],L"irc.chat.org");
	wcscpy(servers[5],L"phoenix.az.us.undernet.org");
#else
	strcpy(servers[0],"irc.gate.net");
	strcpy(servers[1],"irc.emory.edu");
	strcpy(servers[2],"irc.ais.net");	
	strcpy(servers[3],"irc.stealth.net");
	strcpy(servers[4],"irc.chat.org");
	strcpy(servers[5],"phoenix.az.us.undernet.org");
#endif
	NumServers=6;
	strcpy(ServerPort, "6667");
	strcpy(Nickname,"IrcCE");
	strcpy(Userinfo,"IrcCE User");
	
	WSAStartup(MAKEWORD(1,1),&ws);
	StartIdentServer();
	csock=INVALID_SOCKET;
	CreateInfoWin();
	ShowInfoWin(SW_SHOW);
	PrintToScreen("Initializing IrcCE\n","status");
	PrintToScreen("Screen memory allocated\n","status");
	PrintToScreen("IDENT server started.\n","status");
	PrintToScreen("IrcCE v1.00.00 Initialized.\n","status");
	InvalidateRect(hMainWnd, NULL, TRUE);
	// for debugging purposes only
	//	csock = ConnectToHost("vwww.clark.net", 3497);
	//	csock = INVALID_SOCKET;
	return(TRUE);                  // Window handle hWnd is valid.
}
/***************************************************************************

  int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPWSTR lpCmdLine ,UINT nCmdShow)
  
**************************************************************************/
#ifdef _WIN32_WCE
int WINAPI WinMain (HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPWSTR lpCmdLine,
					int nCmdShow)
#else
					int WINAPI WinMain (HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPSTR lpCmdLine,
					int nCmdShow)
#endif
{
	MSG msg;
	
#ifdef _WIN32_WCE
	
	// Start by initializing the common control libraries
	InitCommonControls();	
	//Load the application name and widnow title strings.
	LoadString(hInstance,1,szAppName,
		sizeof(szAppName)/sizeof(TCHAR));
	LoadString(hInstance, 2,szTitle,
		sizeof(szTitle)/sizeof(TCHAR));
#endif
	if (hPrevInstance == 0) {
		if (InitApplication(hInstance) == FALSE)
			return(FALSE);
	}
	
	if (InitInstance(hInstance, nCmdShow) == FALSE)
		return(FALSE);
	
	while (GetMessage(&msg, NULL, 0, 0) == TRUE) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	
	return(msg.wParam);
}


