
#ifndef __IRCCE_H
#define __IRCCE_H

#include <Winsock.h>

#ifdef _WIN32_WCE
#define NUM_SCREEN_LINES	50					// Number of lines stored by the client
#else
#define NUM_SCREEN_LINES	80
#endif

#define CLIENT_VERSION "1.00.00"					// Version of the client


// Structure that holds the information for a single line of text
struct Msg
{
	int state;
	char * text;
	struct Msg * next;
	struct Msg * prev;
};

// Struct hold the info for a channel
struct Channel
{
	char * name;
	struct Msg * pMsgList;
	struct Msg * pEndMsgList;
	int NumBufferLines;
	int window_type;
	SOCKET sock;
	struct Names * pNamesList;
	struct Channel * next;
};


// Struct holds info for a users nickname
struct Names
{
	char name[40];
	char modes[4];
	struct Names * next;
}; 


// Possible window types.
enum {WINDOW_TYPE_DCC_CHAT, WINDOW_TYPE_CHANNEL};


#endif